/*
 * Decompiled with CFR 0.152.
 */
package org.baumfamily.hdprefabexport;

import com.hero.HeroDesigner;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class HDPrefabExport
implements PropertyChangeListener,
Runnable {
    private JMenuItem exportMenuItem;
    private JMenuItem previewMenuItem;
    private JMenuItem templateMenuItem;
    private boolean updatePending;

    public static void main(String[] args) {
        new HDPrefabExport();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.updatePending) {
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        boolean shouldEnable;
        boolean bl = false;
        if (HeroDesigner.getActiveHero() != null) {
            bl = shouldEnable = true;
        }
        if (this.templateMenuItem.isEnabled() != shouldEnable) {
            this.templateMenuItem.setEnabled(shouldEnable);
            this.exportMenuItem.setEnabled(shouldEnable);
            this.previewMenuItem.setEnabled(shouldEnable);
        }
        this.updatePending = false;
    }

    private HDPrefabExport() {
        JMenuBar mb = HeroDesigner.getInstance().getMainMenuBar();
        JMenu menu = mb.getMenu(0);
        int i = 0;
        while (i < menu.getItemCount()) {
            JMenuItem item = menu.getItem(i);
            if (item != null) {
                String text = item.getText();
                if (text.equals("Close Prefab") || text.equals("Close Character")) {
                    item.addPropertyChangeListener("enabled", this);
                } else if (text.equals("Set Export Template...")) {
                    this.templateMenuItem = item;
                    item.addPropertyChangeListener("enabled", this);
                } else if (text.equals("Preview Character...")) {
                    this.previewMenuItem = item;
                } else if (text.equals("Export to File...")) {
                    this.exportMenuItem = item;
                }
            }
            ++i;
        }
        this.run();
    }
}

